"use client"

import { createColumnHelper, type ColumnDef } from "@tanstack/react-table"
import { format } from "date-fns"

export type InventoryItem = {
  id: string
  name: string
  quantity: number
  unitPrice: number
  totalValue: number
  lastUpdated: string
}

const helper = createColumnHelper<InventoryItem>()

export const columns: ColumnDef<InventoryItem, any>[] = [
  helper.accessor("name", {
    header: "Item",
    cell: (info) => info.getValue(),
  }),
  helper.accessor("quantity", {
    header: "Qty",
    cell: (info) => info.getValue().toString(),
  }),
  helper.accessor("unitPrice", {
    header: "Unit Price",
    cell: (info) => `$${info.getValue().toFixed(2)}`,
  }),
  helper.accessor("totalValue", {
    header: "Total Value",
    cell: (info) => `$${info.getValue().toFixed(2)}`,
  }),
  helper.accessor("lastUpdated", {
    header: "Last Updated",
    cell: (info) => format(new Date(info.getValue()), "yyyy-MM-dd"),
  }),
]
