"use client"

import { DashboardCard } from "./dashboard-card"
import { useInventoryMetrics } from "../data/data"

export function DashboardGrid() {
  const metrics = useInventoryMetrics()

  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
      {metrics.map((item, index) => (
        <DashboardCard
          key={index}
          title={item.title}
          value={item.value}
          icon={item.icon}
        />
      ))}
    </div>
  )
}
