"use client"

import {
  Package,
  AlertTriangle,
  XCircle,
  Clock,
  DollarSign,
  TrendingDown,
  TrendingUp,
} from "lucide-react"
import { useTranslations } from "next-intl"

export function useInventoryMetrics() {
  const t = useTranslations("InventoryMetrics")

  return [
    {
      title: t("totalItems"),
      value: 0,
      icon: <Package className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("totalStock"),
      value: 0,
      icon: <Package className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("inventoryValue"),
      value: "0.00",
      icon: <DollarSign className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("lowStockItems"),
      value: 0,
      icon: <AlertTriangle className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("outOfStock"),
      value: 0,
      icon: <XCircle className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("stockAging"),
      value: 0,
      icon: <Clock className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("adjustments"),
      value: 0,
      icon: <TrendingDown className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("consumption"),
      value: 0,
      icon: <TrendingDown className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("purchases"),
      value: 0,
      icon: <TrendingUp className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("expired"),
      value: 0,
      icon: <XCircle className="h-5 w-5 text-muted-foreground" />,
    },
    {
      title: t("expiring"),
      value: 0,
      icon: <AlertTriangle className="h-5 w-5 text-muted-foreground" />,
    },
  ]
}
