"use client";

import { useEffect, useState } from "react";
import { Navbar } from "@/components/inventory/navbar";
import { DashboardGrid } from "./components/dashboard-grid";
import { useTranslations } from "next-intl";
import { DataTable } from "./components/data-table";
import { InventoryItem } from "./components/columns";
import { InventoryService } from "@/lib/api/services/inventoryService";

export default function InventoryPage() {
  const t = useTranslations("InventoryPage");
  const [items, setItems] = useState<InventoryItem[]>([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    // async function fetchItems() {
    //   try {
    //     const data:any = [];
    //     // Adjust mapping to your backend fields
    //     const formatted = data?.data?.map((item: any) => ({
    //       id: String(item.id),
    //       name: item.item_name,
    //       quantity: item.opening_stock,
    //       unitPrice: item.cost_price,
    //       totalValue: item.cost_price * item.opening_stock,
    //       lastUpdated: item.updated_at?.split("T")[0] || "",
    //     }));
    //     setItems(formatted);
    //   } catch (err) {
    //     console.error("Error fetching inventory items:", err);
    //   } finally {
    //     setLoading(false);
    //   }
    // }

    // fetchItems();
  }, []);

  if (loading)
    return (
      <div className="flex justify-center items-center h-64 text-muted-foreground">
        Loading inventory...
      </div>
    );

  return (
    <>
      <div className="w-full max-w-full flex-1 md:flex flex-col p-4 md:p-5 gap-4">
        <div className="flex items-center justify-between gap-2">
          <div className="space-y-0.5">
            <h2 className="text-xl md:text-2xl font-semibold tracking-tight">{t("title")}</h2>
            <p className="text-sm text-muted-foreground">{t("subtitle")}</p>
          </div>
        </div>

        <DashboardGrid />

        <div>
          <DataTable data={items} />
        </div>
      </div>
    </>
  );
}
