// app/(inventory)/reports/_components/report-helpers.tsx
"use client"
import * as React from "react"
import { Button } from "@/components/ui/button"

export function Field({
  label, className, children,
}: React.PropsWithChildren<{ label: string; className?: string }>) {
  return (
    <div className={className}>
      <label className="mb-1 block text-sm font-semibold text-foreground">{label}</label>
      {children}
    </div>
  )
}

export function PrintButton({ label }: { label: string }) {
  return <Button variant="outline" onClick={() => window.print()}>{label}</Button>
}
