"use client"

import * as React from "react"
import { useTranslations } from "next-intl"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import {
  Table, TableHeader, TableRow, TableHead, TableBody, TableCell
} from "@/components/ui/table"
import {
  Select, SelectTrigger, SelectValue, SelectContent, SelectItem
} from "@/components/ui/select"
import { Printer, FileDown } from "lucide-react"

type StockHistoryRow = {
  id: string
  date: string
  type: string
  qty: number
  cost: number
  batch: string
  expiry: string
  reference: string
  notes: string
  createdBy: string
  availableQty: number
}

export default function StockHistoryPage() {
  const t = useTranslations("StockHistory")
  const [item, setItem] = React.useState("all")
  const [from, setFrom] = React.useState(new Date().toISOString().slice(0, 10))
  const [to, setTo] = React.useState(new Date().toISOString().slice(0, 10))

  const rows: StockHistoryRow[] = [
    {
      id: "1",
      date: "2025-08-16",
      type: "Purchase",
      qty: 100,
      cost: 25,
      batch: "B123",
      expiry: "2026-01-01",
      reference: "INV-1001",
      notes: "Initial stock",
      createdBy: "Admin",
      availableQty: 80
    }
    // Add more rows as needed
  ]

  return (
    <div className="w-full p-4 sm:p-6 lg:p-8 space-y-6">
      {/* Filters */}
      <div className="flex flex-wrap items-end gap-4">
        <div>
          <label className="block text-sm text-muted-foreground mb-1">{t("items")}</label>
          <Select value={item} onValueChange={setItem}>
            <SelectTrigger className="h-9 min-w-[160px]">
              <SelectValue placeholder={t("all")} />
            </SelectTrigger>
            <SelectContent>
              <SelectItem value="all">{t("all")}</SelectItem>
              {/* Add dynamic items if needed */}
            </SelectContent>
          </Select>
        </div>
        <div>
          <label className="block text-sm text-muted-foreground mb-1">{t("dateFrom")}</label>
          <Input className="h-9" type="date" value={from} onChange={(e) => setFrom(e.target.value)} />
        </div>
        <div>
          <label className="block text-sm text-muted-foreground mb-1">{t("dateTo")}</label>
          <Input className="h-9" type="date" value={to} onChange={(e) => setTo(e.target.value)} />
        </div>
        <div className="ml-auto flex gap-2">
          <Button variant="outline">
            <Printer className="mr-2 size-4" />
            {t("print")}
          </Button>
          <Button variant="outline">
            <FileDown className="mr-2 size-4" />
            {t("export")}
          </Button>
        </div>
      </div>

      <h2 className="text-3xl font-semibold">{t("title")}</h2>

      {/* Table */}
      <div className="overflow-x-auto rounded-md border">
        <Table className="w-full">
          <TableHeader>
            <TableRow>
              <TableHead>{t("date")}</TableHead>
              <TableHead>{t("type")}</TableHead>
              <TableHead>{t("qty")}</TableHead>
              <TableHead>{t("availableQty")}</TableHead>
              <TableHead>{t("cost")}</TableHead>
              <TableHead>{t("batch")}</TableHead>
              <TableHead>{t("expiry")}</TableHead>
              <TableHead>{t("reference")}</TableHead>
              <TableHead>{t("notes")}</TableHead>
              <TableHead>{t("createdBy")}</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>
            {rows.length > 0 ? (
              rows.map((r) => (
                <TableRow key={r.id}>
                  <TableCell>{r.date}</TableCell>
                  <TableCell>{r.type}</TableCell>
                  <TableCell>{r.qty}</TableCell>
                  <TableCell>{r.availableQty}</TableCell>
                  <TableCell>{r.cost}</TableCell>
                  <TableCell>{r.batch}</TableCell>
                  <TableCell>{r.expiry}</TableCell>
                  <TableCell>{r.reference}</TableCell>
                  <TableCell>{r.notes}</TableCell>
                  <TableCell>{r.createdBy}</TableCell>
                </TableRow>
              ))
            ) : (
              <TableRow>
                <TableCell colSpan={10} className="text-center text-muted-foreground">
                  {t("noData")}
                </TableCell>
              </TableRow>
            )}
          </TableBody>
        </Table>
      </div>
    </div>
  )
}
