"use client"

import * as React from "react"
import { useTranslations } from "next-intl"
import { Plus, Pencil, Trash2, ChevronLeft, ChevronRight, ChevronsLeft, ChevronsRight, Download, Printer } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Checkbox } from "@/components/ui/checkbox"
import {
  Select, SelectTrigger, SelectValue, SelectContent, SelectItem
} from "@/components/ui/select"
import {
  Table, TableHeader, TableRow, TableHead, TableBody, TableCell
} from "@/components/ui/table"
import { useGenericTable } from "@/lib/hooks/useGenericTable"
import { API_ENDPOINTS } from "@/lib/api/endpoints"
import { useEffect, useState } from "react"
import { DeleteButton } from "@/components/DeleteButton"
import { TableSkeleton } from "@/components/ui/table-skeleton"
import { DynamicModal } from "@/components/common/dynamicModal"
import { useForm } from "react-hook-form"
import { toast } from "sonner"
import SubmitBtnClient from "@/components/submit-client-button"
import { Card, CardHeader, CardTitle, CardDescription, CardContent } from "@/components/ui/card"
import { LinkAsButton } from "@/components/ui/link-button"
import { Label } from "@radix-ui/react-label"
import { title } from "process"
import { debug } from "console"

export default function SuppliersPage() {
  const url = API_ENDPOINTS.INVENTORY.STORES;
  const { data, loading, error, pagination, fetchData, save, deleteItem, getItem, update } = useGenericTable({ url });
  const t = useTranslations("Stores");
  const [editing, setEditing] = React.useState(false)
  const [searchFilters, setSearchFilters] = useState<any>([]);
  const [createModal, setCreateModal] = useState(false);
  const [form, setForm] = React.useState<any>();
  const [isSubmitting, setIsSubmitting] = useState<boolean>(false);
  const [fields, setfields] = useState<any>([]);

  useEffect(() => {

    setfields([
      { label: t("storeName"), data: { type: "text", props: "", key: "name", value: "" } },
      { label: t("doctorIds"), data: { type: "select", props: "", key: "doctor_ids", value: "" } },
      { label: t("roomNumbers"), data: { type: "select", props: "", key: "room_numbers", value: "" } },
      { label: t("coaAccountId"), data: { type: "select", props: "", key: "coa_account_id", value: "" } },
    ]);

  }, [])




  const titleCreate = {
    title: t("addStore"),
    desc: t("addStoreDesc")
  }

  const titleEdit = {
    title: t("editStore"),
    desc: t("editStoreDesc")
  }


  const startEdit = async (u: any) => {



    try {
      setIsSubmitting(true)
      // const data = await getItem(u.id);
      setForm(u);
      setEditing(true);
      setIsSubmitting(false)
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  }

  const handleSearch = (field: string, value: string) => {
    setSearchFilters((prev: any) => ({ ...prev, [field]: value }))
  }


  const buildSearchParams =
    (page: number = 1) => {
      const params = new URLSearchParams({
        page: page.toString(),
        per_page: "10",
      });

      if (searchFilters?.barcode) {
        params.set("name", searchFilters.barcode);
      }
      return params.toString();
    };

  // Fetch user when search filters change
  useEffect(() => {
    debugger;
    const params = buildSearchParams(1)
    fetchData(params)
  }, [searchFilters])

  // Handle pagination
  const handlePageChange = ((newPage: number) => {
    debugger;
    const params = buildSearchParams(newPage)
    fetchData(params);
  })

  const handleSave = async (methods: any) => {
    try {
      const form = methods.getValues();

      await save(form);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setCreateModal(false)
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  const handleUpdate = async (methods: any) => {
    try {
      const data = methods.getValues();

      await update(data, form?.id);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setEditing(false);
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  const handleDelete = async (methods: any) => {

    try {
      debugger;
      await deleteItem(methods)
      const params = buildSearchParams(1);
      fetchData(params);
    } catch (error: any) {
    } finally {

    }
  }

  return (
    <div className="p-2 space-y-6">

      <Card className="mb-6">
        <CardHeader>
          <CardTitle className="text-lg">
            <div className="flex flex-wrap items-center justify-between gap-3">
              <div className="flex items-center gap-2">
                <h2 className="text-3xl font-semibold text-gray-700">{t("title")}</h2>
              </div>

              <div className="flex items-center gap-2">
                <Button onClick={() => { setCreateModal(true) }}>
                  <Plus className="mr-2 size-4" />
                  {t("addStore")}
                </Button>
                <Button variant="outline">
                  <Printer className="mr-2 size-4" />
                  {t("print")}
                </Button>
                <Button variant="outline">
                  <Download className="mr-2 size-4" />
                  {t("export")}
                </Button>
              </div>
            </div>
          </CardTitle>
          <CardDescription>{t("sup_des")}</CardDescription>
        </CardHeader>
        <CardContent>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <div className="space-y-2">
              <Label htmlFor="name">{t("storeName")}</Label>
              <Input
                id="name"
                placeholder={`${t("search_by")} ${t(
                  "name"
                )}`}
                value={searchFilters.name || ""}
                onChange={(e) => handleSearch("name", e.target.value)}
              />
            </div>
          </div>
        </CardContent>
      </Card>

      {/* Table */}
      <div className="rounded-md border overflow-hidden space-y-4 p-1">

        <div className="flex items-center justify-between text-sm text-gray-600">
          <span>
            {pagination && (
              <div>
                Showing{" "}
                {(pagination.currentPage - 1) * pagination.itemsPerPage + 1} to{" "}
                {Math.min(
                  pagination.currentPage * pagination.itemsPerPage,
                  pagination.totalItems
                )}{" "}
                of {pagination.totalItems} entries
              </div>
            )}
          </span>
        </div>
        {loading ? (<TableSkeleton columns={6} rows={10} />) : (
          <Table>
            <TableHeader>
              <TableRow>
                <TableHead className="w-16">#</TableHead>
                <TableHead>{t("storeName")}</TableHead>
                <TableHead>{t("doctorIds")}</TableHead>
                <TableHead>{t("roomNumbers")}</TableHead>
                <TableHead>{t("coaAccountId")}</TableHead>
                <TableHead className="w-28 text-right">{t("actions")}</TableHead>
              </TableRow>
            </TableHeader>
            <TableBody>
              {data.length === 0 ? (
                <TableRow><TableCell colSpan={6} className="text-center text-muted-foreground">{t("noData")}</TableCell></TableRow>
              ) : data.map((u: any, i: any) => (
                <TableRow key={u.id}>
                  <TableCell>{u.id}</TableCell>
                  <TableCell>{u.name}</TableCell>
                  <TableCell>{u.email}</TableCell>
                  <TableCell>{u.phone}</TableCell>
                  <TableCell>{u.phone}</TableCell>
                  <TableCell className="text-right space-x-2">
                    <Button key={u.id} variant={"ghost"} onClick={() => startEdit(u)}><Pencil className="size-4" /></Button>
                    <DeleteButton onConfirm={() => handleDelete(u.id)} />
                  </TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        )}

        {pagination?.totalPages > 1 && (
          <div className="flex items-center justify-between">
            <div className="text-sm text-gray-600">
              Page {pagination.currentPage} of {pagination.totalPages}
            </div>
            <div className="flex items-center space-x-2">
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronsLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage - 1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage + 1)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronRight className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(pagination.totalPages)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronsRight className="h-4 w-4" />
              </Button>
            </div>
          </div>
        )}

        <DynamicModal
          key={Number(createModal)}
          title={titleCreate}
          isOpen={createModal}
          loading={loading}
          openChange={setCreateModal}
          onConfirm={handleSave} fieldset={fields} columns={2} />

        <DynamicModal
          key={String(form?.name + form?.id)}
          title={titleEdit}
          isOpen={editing}
          loading={loading}
          openChange={setEditing}
          isLoading={isSubmitting}
          type="edit"
          onConfirm={handleUpdate} fieldset={fields} values={form} columns={2} />

      </div>
    </div>
  )
}
