"use client"

import * as React from "react"
import { useTranslations } from "next-intl"
import { Plus, Pencil, Trash2, ChevronLeft, ChevronRight, ChevronsLeft, ChevronsRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Checkbox } from "@/components/ui/checkbox"
import {
  Select, SelectTrigger, SelectValue, SelectContent, SelectItem
} from "@/components/ui/select"
import {
  Table, TableHeader, TableRow, TableHead, TableBody, TableCell
} from "@/components/ui/table"
import { useGenericTable } from "@/lib/hooks/useGenericTable"
import { API_ENDPOINTS } from "@/lib/api/endpoints"
import { useEffect, useState } from "react"
import { DeleteButton } from "@/components/DeleteButton"
import { TableSkeleton } from "@/components/ui/table-skeleton"
import { DynamicModal } from "@/components/common/dynamicModal"
import { useForm } from "react-hook-form"
import { toast } from "sonner"
import SubmitBtnClient from "@/components/submit-client-button"

type Uom = { id: string; name: string; symbol: string; category: string; base: boolean }

const seed: Uom[] = [
  { id: "1", name: "Box", symbol: "BX", category: "Units", base: true },
  { id: "2", name: "Pieces", symbol: "pc", category: "Units", base: false },
  { id: "3", name: "Pack", symbol: "PK", category: "Units", base: false },
]

export default function UnitsPage() {
  const url = API_ENDPOINTS.INVENTORY.UNIT;
  const { data, loading, error, pagination, fetchData, save, deleteItem, getItem, update } = useGenericTable({ url });
  const t = useTranslations("Units")
  const [rows, setRows] = React.useState(seed)
  const [open, setOpen] = React.useState(false)
  const [editing, setEditing] = React.useState(false)
  const [searchFilters, setSearchFilters] = useState<any>([]);
  const [createModal, setCreateModal] = useState(false);
  const [selected, setSelected] = useState<string>("");
  const [form, setForm] = React.useState<any>();
  const [isSubmitting, setIsSubmitting] = useState<boolean>(false);


  const addUnit = [
    { label: t("unitName"), data: { type: "text", props: "", key: "name",value: "" } },
    { label: t("symbol"), data: { type: "text", props: "", key: "symbol",value: ""  } },
    {
      label: t("category"), data: {
        type: "select", props: [
          { value: "Units", label: t("cat.units") },
          { value: "Weight", label: t("cat.weight") },
          { value: "Volume", label: t("cat.volume") },
          { value: "Length", label: t("cat.length") }], key: "category",value: "" 
      }
    },
    {
      label: t('baseUnit'), data: {
        type: "select", props:
          [
            { value: "1", label: t("yes") },
            { value: "0", label: t("no") }], key: "is_base",value: "" 
      }
    }
  ];

  const titleStock = {
    title: t("addUnit"),
    desc: t("addUnitDesc")
  }

  const titleStockEdit = {
    title: t("editUnit"),
    desc: t("editUnitDesc")
  }


  const startEdit = async (u: any) => {


      
    try {
      setIsSubmitting(true)
      // const data = await getItem(u.id);
      setForm(u);
      setSelected(u);
      setEditing(true);
      setIsSubmitting(false)
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  }


  const buildSearchParams =
    (page: number = 1) => {
      const params = new URLSearchParams({
        page: page.toString(),
        per_page: "10",
      });

      if (searchFilters?.barcode) {
        params.set("barcode", searchFilters.barcode);
      }
      if (searchFilters?.name) {
        params.set("item_name", searchFilters.name);
      }
      return params.toString();
    };

  // Fetch user when search filters change
  useEffect(() => {
    debugger;
    const params = buildSearchParams(1)
    fetchData(params)
  }, [searchFilters])

  // Handle pagination
  const handlePageChange = ((newPage: number) => {
    debugger;
    const params = buildSearchParams(newPage)
    fetchData(params);
  })

  const handleSave = async (methods: any) => {
    try {
      const form = methods.getValues();

      await save(form);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setCreateModal(false)
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  const handleUpdate = async (methods: any) => {
    try {
      const data = methods.getValues();

      await update(data, form?.id);
      debugger;
      const params = buildSearchParams(1);
      fetchData(params);
      setEditing(false);
      return true;

    } catch (error: any) {
      return false;
    } finally {

    }
  };

  return (
    <div className="p-2 space-y-6">
      <div className="flex items-center justify-between">
        <h1 className="text-2xl font-semibold">{t("title")}</h1>
        <Button onClick={() => { setCreateModal(true) }}>
          <Plus className="mr-2 size-4" />
          {open ? t("closeAdd") : t("newUnit")}
        </Button>
      </div>

      {/* Table */}
      <div className="rounded-md border overflow-hidden space-y-4 p-1">

        <div className="flex items-center justify-between text-sm text-gray-600">
          <span>
            {pagination && (
              <div>
                Showing{" "}
                {(pagination.currentPage - 1) * pagination.itemsPerPage + 1} to{" "}
                {Math.min(
                  pagination.currentPage * pagination.itemsPerPage,
                  pagination.totalItems
                )}{" "}
                of {pagination.totalItems} entries
              </div>
            )}
          </span>
        </div>
        {loading ? (<TableSkeleton columns={6} rows={10} />) : (
          <Table>
            <TableHeader>
              <TableRow>
                <TableHead className="w-16">#</TableHead>
                <TableHead>{t("name")}</TableHead>
                <TableHead>{t("symbol")}</TableHead>
                <TableHead>{t("category")}</TableHead>
                <TableHead>{t("baseUnitShort")}</TableHead>
                <TableHead className="w-28 text-right">{t("actions")}</TableHead>
              </TableRow>
            </TableHeader>
            <TableBody>
              {data.length === 0 ? (
                <TableRow><TableCell colSpan={6} className="text-center text-muted-foreground">{t("noData")}</TableCell></TableRow>
              ) : data.map((u: any, i: any) => (
                <TableRow key={u.id}>
                  <TableCell>{u.id}</TableCell>
                  <TableCell>{u.name}</TableCell>
                  <TableCell>{u.symbol}</TableCell>
                  <TableCell>{u.category}</TableCell>
                  <TableCell>{u.is_base ? t("yes") : "-"}</TableCell>
                  <TableCell className="text-right space-x-2">
                    <Button key={u.id} variant={"ghost"} onClick={() => startEdit(u)}><Pencil className="size-4" /></Button>
                    <DeleteButton  onConfirm={() => deleteItem(u.id)} />
                  </TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        )}

        {pagination?.totalPages > 1 && (
          <div className="flex items-center justify-between">
            <div className="text-sm text-gray-600">
              Page {pagination.currentPage} of {pagination.totalPages}
            </div>
            <div className="flex items-center space-x-2">
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronsLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage - 1)}
                disabled={pagination.currentPage === 1}
              >
                <ChevronLeft className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                size="sm"
                onClick={() => handlePageChange(pagination.currentPage + 1)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronRight className="h-4 w-4" />
              </Button>
              <Button
                variant="outline"
                className="hidden h-8 w-8 p-0 lg:flex"
                onClick={() => handlePageChange(pagination.totalPages)}
                disabled={pagination.currentPage === pagination.totalPages}
              >
                <ChevronsRight className="h-4 w-4" />
              </Button>
            </div>
          </div>
        )}

        <DynamicModal
          key={Number(createModal)}
          title={titleStock}
          isOpen={createModal}
          loading={loading}
          openChange={setCreateModal}
          onConfirm={handleSave} fieldset={addUnit} columns={2} />

        <DynamicModal
          key={Number(form?.id)}
          title={titleStockEdit}
          isOpen={editing}
          loading={loading}
          openChange={setEditing}
          isLoading={isSubmitting}
          type="edit"
          onConfirm={handleUpdate} fieldset={addUnit} values={form} columns={2} />

      </div>
    </div>
  )
}
