const users = {};
let user_id=null;
module.exports = (io, dbConnection) => {
    io.on('connection', (socket) => {
        console.log('User connected:', socket.id);

        // Fetch all users from the database and emit to the newly connected user
         fetchAllUsers();

        // User joins and sends their user ID
        socket.on('chatuserConnected', (userId) => {
            console.log('User connected:', userId);
            users[userId] = { socketId: socket.id, online: true };
            user_id=userId;
            // Emit updated user list to all connected clients
             io.emit('updateUserListOnline',user_id);
           
        });

        // Handle user disconnection
        socket.on('disconnect', () => {
            console.log('User disconnected:', socket.id);
            for (const userId in users) {
                if (users[userId].socketId === socket.id) {
                    users[userId].online = false; // Set user as offline
                    break; // Exit loop once the user is found
                }
            }

            // Emit updated user list to all connected clients
            fetchAllUsers();
        });
        socket.on('updateUserList', () => {
          
            fetchAllUsers();
        });
        socket.on('updateUserListSing', () => {
          
            fetchAllUsers();
        });

        // Send chat message
        socket.on('sendMessage', (data) => {
            const { fromUserId, toUserId, message } = data;
        
            // Insert the message into the database
            const insertQuery = `
                INSERT INTO ac_messages (m_from, m_to, message, is_read, dt_updated) 
                VALUES (?, ?, ?, 0, NOW())
            `;
        
            dbConnection.query(insertQuery, [fromUserId, toUserId, message], (err, results) => {
                if (err) {
                    console.error('Error sending message:', err);
                    return;
                }
        
                // After inserting, emit the message to the recipient
                const newMessage = {
                    id: results.insertId, // Get the inserted ID
                    m_from: fromUserId,
                    m_to: toUserId,
                    message: message,
                    is_read: 0,
                    dt_updated: new Date() // Current date
                };
        
                // Find the socket ID of the recipient
                const recipientSocketId = users[toUserId] ? users[toUserId].socketId : null;

                console.log('Recipient Socket ID:', recipientSocketId);
                
                if (recipientSocketId) {
                    // Emit the message to the recipient using their socket ID
                    io.to(recipientSocketId).emit('receiveMessage', newMessage);
                    getAllUsers(toUserId).then(usersWithStatus => {
                        io.to(recipientSocketId).emit('updateUserList', usersWithStatus);
                    }).catch(err => {
                        console.error('Failed to fetch users for recipient:', err);
                    });
                }
               
                // Emit the message to the sender as well, if needed
                socket.emit('receiveMessage', newMessage);
            });
        });
        socket.on('markAsRead', ({ messageId }) => {
            const updateReadStatusQuery = `
                UPDATE ac_messages 
                SET is_read = 1 
                WHERE id = ?
            `;
           
            dbConnection.query(updateReadStatusQuery, [messageId], (err) => {
                if (err) {
                    console.error('Error updating read status:', err);
                    return;
                }
            });
            io.emit('markedAsRead', messageId); 
            console.log(messageId);
        });
        socket.on('fetchMessages', (data) => {
            const { fromUserId, toUserId } = data;
    
            const query = `
                SELECT * FROM ac_messages 
                WHERE (m_from = ? AND m_to = ?) OR (m_from = ? AND m_to = ?)
                ORDER BY dt_updated
            `;
    
            dbConnection.query(query, [fromUserId, toUserId, toUserId, fromUserId], (err, results) => {
                            if (err) {
                                console.error('Error fetching messages:', err);
                                return;
                            }
                            // Collect the IDs of all unread messages to mark them as read
                            const unreadMessageIds = results
                            .filter(msg => msg.is_read == 0 && msg.m_to == fromUserId) // Mark only if the recipient is the one opening the chat
                            .map(msg => msg.id);
                
                if (unreadMessageIds.length > 0) {
                    // Update the read status before sending the messages to the client
                    const updateQuery = `
                        UPDATE ac_messages 
                        SET is_read = 1 
                        WHERE id IN (?)
                    `;
                    dbConnection.query(updateQuery, [unreadMessageIds], (updateErr) => {
                        if (updateErr) {
                            console.error('Error updating message status:', updateErr);
                            return;
                        }

                        // Once the status is updated, send the messages to the client
                        socket.emit('receiveMessages', results);
                        
                    });
                } else {
                    // If there are no unread messages, just send the messages directly
                    socket.emit('receiveMessages', results);
                }
    
                // Emit messages to the requesting user
                
            });
        });
        socket.on('message_read', (data) => {
            const { messageId } = data;
    
                    io.emit('message_read_update', { messageId });
               
        });
    });
   

    // Helper function to get all users from the database and merge online status
    function getAllUsers(forUserId) {
        console.log(user_id);
        return new Promise((resolve, reject) => {
            
            const query = `
            SELECT u.user_Id, u.full_name, 
                (SELECT COUNT(*) 
                 FROM ac_messages 
                 WHERE m_to = ? 
                   AND m_from = u.user_Id 
                   AND is_read = 0) AS unreadCount,
                (SELECT message 
                 FROM ac_messages 
                 WHERE (m_to = ? 
                    AND m_from = u.user_Id) 
                    OR (m_to = u.user_Id 
                    AND m_from = ?) 
                 ORDER BY dt_updated DESC 
                 LIMIT 1) AS lastMessage,
                (SELECT dt_updated 
                 FROM ac_messages 
                 WHERE (m_to = ? 
                    AND m_from = u.user_Id) 
                    OR (m_to = u.user_Id 
                    AND m_from = ?) 
                 ORDER BY dt_updated DESC 
                 LIMIT 1) AS lastMessageTime
            FROM tbl_users u
            WHERE u.user_group_id != 1
            ORDER BY lastMessageTime DESC
        `;
       
        dbConnection.query(query, [forUserId,forUserId,forUserId,forUserId,forUserId], (err, results) => {
                if (err) {
                    console.error('Error fetching users:', err.stack);
                    return reject(err);
                }

                // Map results to include online status
                const usersWithStatus = results.map(user => ({
                    userId: user.user_Id,
                    count: user.unreadCount ?? 0,
                    fullName: user.full_name,
                    lastMessage: user.lastMessage,
                    online: users[user.user_Id] ? users[user.user_Id].online : false // Check if the user is online
                }));

                resolve(usersWithStatus);
            });
        });
    }

    // Fetch all users and emit to clients
    function fetchAllUsers() {
        // For each user connected, fetch their data
        Object.keys(users).forEach((userId) => {
            getAllUsers(userId).then(usersWithStatus => {
                // Emit the updated user list to the specific user
                io.to(users[userId].socketId).emit('updateUserList', usersWithStatus);
            }).catch(err => {
                console.error('Failed to fetch users for user:', userId, err);
            });
        });
    }
};
